/**
 * 
 */
package gov.va.genisis2.service;

import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.RefreshHistory;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserCount;

import java.util.Date;
import java.util.List;

/**
 * @author Getaneh Kassahun
 *
 */
public interface IUserManagementService {
	public User getUserDetailsByEmail(String email) throws GenisisServiceException;

	public User getUserDetailsById(int id) throws GenisisServiceException;

	public String getUserRole(int uid) throws GenisisServiceException;
	
	public User getUserDetailsByUsername(String username) throws GenisisServiceException;
	
	public List<User> getUserDetailsByRoleTypeId(int roleTypeId) throws GenisisServiceException;
	
	public List<UserCount> getUserCountOnRole() throws GenisisServiceException;

	public Date getLatestUserRefreshHistory() throws GenisisServiceException;
	
	public int createUserRefreshHistory(RefreshHistory refreshHistory) throws GenisisServiceException;
	
	public RefreshHistory updateUserRefreshHistory(RefreshHistory refreshHistory) throws GenisisServiceException;
	
	public void refreshUsers(String username) throws GenisisServiceException;
}
